<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('communications', function (Blueprint $table) {
            $table->id();

            // Link to either customer or corporate customer
            $table->foreignId('customer_id')->nullable()->constrained('customers')->onDelete('cascade');
            $table->foreignId('corporate_customer_id')->nullable()->constrained('corporate_customers')->onDelete('cascade');

            // Communication channel used
            $table->enum('channel', ['email', 'phone', 'sms', 'whatsapp', 'telegram', 'in-person'])->default('email');
            $table->enum('direction', ['incoming', 'outgoing'])->default('outgoing');

            // Whether this channel matches the user's preference
            $table->boolean('matched_preference')->default(true); // True if communication matches preferred channel

            // Communication content
            $table->string('subject')->nullable();
            $table->text('message')->nullable();
            $table->timestamp('sent_at')->nullable();

            // Optional attachments
            $table->string('attachment_path')->nullable();
            $table->string('attachment_name')->nullable();
            $table->string('attachment_mime_type')->nullable();
            $table->unsignedBigInteger('attachment_size')->nullable();

            // Internal tracking
            $table->foreignId('handled_by')->nullable()->constrained('users')->nullOnDelete(); // Staff member

            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('communications');
    }
};
